//Example 11.8
//Calculate following question on simple Brayton cycle
clear
clc
T1 = 300; //[K]
T0 = T1; //[K]
T3 = 1250; //[K]
rp = 10; // pressure ratio rp = P2/P1
Cp = 1.005;  //[kJ/kg K]specific heat
gama = 1.4
T_source = 1550; //[K]
T_sink = 310; //[K]
R = 0.287; //[kJ/kg K]
//For process 1-2 T2/T1 = (P2/P1)^(gama -1/gama)
T2 = T1*[(rp)^( (gama -1)/gama)]; //[K]
T4 = T3*[(1/rp)^( (gama -1)/gama )]; //[K]
q1 = Cp*(T3 - T2); //[kJ/kg]
q2 = Cp*(T4 - T1); //[kJ/kg]
s2 = 2.363; //[kJ/kg K] From ideal gas properties of air at T2
s3 = 3.226; //[kJ/kg K] From ideal gas properties of air at T3
s1 = s2; //[kJ/kg K]
s4 = s3; //[kJ/kg K]
// For process 2-3 (s3_1 - s2_1)= del_s_32 = s3 -s2 - R*log(P3/P2) where P3 = P2
del_s_32 = s3 - s2 - R*log(1); //s3_1 - s2_1 = del_s_32
del_s_14 = -del_s_32; // s1_1 - s4_1 = del_s_14
//(i) Find exergy destruction associated with each process of the cycle
X_destroyed_12 = 0;
X_destroyed_34 = 0;
X_destroyed_23 = T0*[(del_s_32) - (q1/T_source) ]; //[kJ/kg]
X_destroyed_41 = T0*[(del_s_14) + (q2/T_sink)]; //[kJ/kg]
disp('Exergy destruction in process 1-2 = ',X_destroyed_12)
disp('Exergy destruction in process 2-3 = ',X_destroyed_23,'kJ/kg')
disp('Exergy destruction in process 3-4 = ',X_destroyed_34)
disp('Exergy destruction in process 4-1 = ',X_destroyed_41,'kJ/kg')
X_heat_in = [1 - (T0/T_source)]*q1; //[kJ/kg]
X_supplied = X_heat_in; //[kJ/kg]
//(ii) Find total exergy destruction of the cycle
X_destroyed = X_destroyed_12+X_destroyed_23+X_destroyed_34+X_destroyed_41; //[kJ/kg]
disp('Total exergy destruction = ',X_destroyed,'kJ/kg')
//(iii) Find the second law efficiency of the cycle
eta_pi = [1 - (X_destroyed/X_supplied)]*100; //[%]
disp('Second-law efficiency of the cycle = ',eta_pi,'%')
