//Example 11.6
// Determine efficiency of the plant
clear
clc
m = 1.2; //[kg/s]
T1 = 273 + 27; //[K]
T3 = T1; //[K]
T5 = 273 + 723; //[K] Tmax
pr = 6; //pressure ratio P4/P1
P2_1 = sqrt(pr); // P2/P1 = P4/P3 
gama = 1.4;
Cp = 1.005;
T2_1 = T1*(P2_1)^( (gama -1)/gama ); //[K]
eta_comp_LP = 0.85; 
T2 = ( (T2_1 - T1)/eta_comp_LP ) + T1; //[K]
Wc = 2*m*Cp*(T2 - T1); //[kW]
P5_6 = pr; // P5/P6
T6_1 = T5/[P5_6^( (gama -1)/gama )]; //[K]
eta_T = 0.90; 
T6 = T5 - [(T5 - T6_1)/eta_T];  //[K]
WT = m*Cp*(T5 - T6); //[kW]
Wnet = WT - Wc; //[kW]
T4_1 = T2; //[K]
T4 =  ( (T4_1 - T3)/eta_comp_LP ) + T3; //[K]
Q1 = m*Cp*(T5 - T4); //[kJ/s]
eta = (Wnet/Q1)*100; //[%]
disp('Cycle efficiency = ',eta,'%')
// The answer provided in textbook is wrong
