//Example 11.2
//Calculation on air standard Diesel cycle
clear
clc
p1 = 1.1*100; //[kPa]
T1 = 273 + 35; //[K]
// Compression ratio rk = 17:1 and rk = v1/v2
rk = 17;
q1 = 1.8*1000;//[kJ/kg] 
Cp = 1.005; //[kJ/kg K]
Cv = 0.718; //[kJ/kg K]
// T2/T1 = (v1/v2)^(gama - 1)
gama = 1.4;
T2 = T1*[rk^(gama -1)]; //[K]
// Estimate maximum temperature of the cycle 
T3 = (q1/Cp) + T2; //[K]  Maximum temperature of the cycle Tmax = T3
// Estimate the cutoff ratio
// For process 2-3 (p2*v2)/T2 = (p3*v3)/T3 & p2 =p3
// Cut off ratio (v3/v2) = T3/T2
C_R = T3/T2; //C_R = v3/v2  cutoff ratio
// Estimate the temperature at the end of isentropic expansion
//For process 3-4 T3/T4 = (v4/v3)^(gama-1)  = [(v1/v2)*(v2/v3)]^(gama-1)
T4 = T3/[(rk/C_R)^(gama-1)]; //[K]  where rk=v1/v2 and C_R = v3/v2
q2 = Cv*(T4 - T1); //[kJ/kg]
// Estimate the work done per kg of air
W_net = q1 - q2; //[kJ/kg]  
// Estimate eta_cycle
eta_cycle = [1-(q2/q1)]*100; 
R = 0.283; 
v1 = (R*T1)/p1; //[m^3/kg]  p1*v1=R*T1
v2 = v1/rk; //[m^3/kg]
// Estimate the maximum pressure
p2 = (R*T2)/v2; //[kPa]
// Estimate the MEP of cycle
MEP = W_net/(v1 - v2);//[kPa]
disp('The maximum temperature of the cycle = ',T3,'K') //(i)
disp('The work done per kg of air = ',W_net,'kJ/kg') //(ii)
disp('The maximum pressure = ',p2/1000,'MPa') //(iii)
disp('eta_cycle = ',eta_cycle,'%') //(iv)
disp('The temperature at the end of isentropic expansion = ',T4,'K')  //(v)
disp('Cutoff ratio = ',C_R)  //(vi)
disp('The MEP of cycle = ',MEP/1000,'MPa') //(vii)
// The answer vary due to round off error
