//Example 9.6
//Determine temperature and rate of exergy destruction
clear
clc
mh = 800; //[kg/h]  mass flow rate of oil
Cph = 2.1; //[kJ/kg K]  specific heat of oil at constant pressure
Th1 = 440; //[K]
Th2 = 320; //[K]
mc = 3200; //[kg/h]  mass flow rate of water
Cpc = 4.2; //[kJ/kg K]  specific heat of water at constant pressure
Tc1 = 290; //[K]
//(i) Calculate temperature T
//Energy balance between oil and water,  mh*Cph*(Th1 - Th2)=mc*Cpc*(Tc2 - Tc1)
T = [ ( mh*Cph*(Th1 - Th2) )/(mc*Cpc) ] + Tc1; //[K] 
disp('The final temperature of water after heating , T = ' , T , 'K')
//(ii) Calculate the rate of exergy destruction
// del_S_total = del_s_oil + del_s_water
function s = f (T)
    s = (mh*Cph)/T; 
endfunction
del_s_oil = intg(Th1, Th2, f);  //[kJ/K]
function s1= f1 (T)
    s1 = (mc*Cpc)/T;
endfunction
del_s_water = intg(Tc1, T, f1); //[kJ/K]
del_S_total = del_s_oil + del_s_water; 
X_destroyed = (Tc1 * del_S_total)/1000; //[MJ/h]
disp('Rate of exergy destruction = ',X_destroyed,'MJ/h')
