//Example 8.9
//Compute Specific heats and change in Internal energy, Enthalpy and Entropy
clear
clc
m_O2 = 5; //[kg]
m_CO2 = 2; //[kg]
T1 = 298; //[K]
T2 = 323; //[K]
Cp_O2 = 0.9094; //[kJ/kg K]
Cp_CO2 = 0.662; //[kJ/kg K]
Cv_O2 = 0.649; //[kJ/kg K]
Cv_CO2 = 0.472;  //[kJ/kg K]
P1 = 250; //[kPa]
//(i) Compute the specific heats
Cp = (m_O2*Cp_O2 + m_CO2*Cp_CO2)/(m_O2 + m_CO2); //[kJ/kg K] at constant pressure
Cv = (m_O2*Cv_O2 + m_CO2*Cv_CO2)/(m_O2 + m_CO2); //[kJ/kg K] at constant volume
disp('Specific heat at constant pressure of mixture = ',Cp,'kJ/kg K')
disp('Specific heat at constant volume of mixture = ',Cv,'kJ/kg K')
//(ii) Compute internal energy, enthalpy and entropy of the mixture
m = m_O2 + m_CO2; //[kg]
del_U = m*Cv*(T2 - T1); //[kJ] change in internal energy
del_H = m*Cp*(T2 - T1); //[kJ] change in enthalpy
// del_s = m*[Cp*log(T2/T1) - R*log(P2/P1)] , but P2 = P1 so R*log(P2/P1)=0
del_s = m*Cp*log(T2/T1); // [kJ/K] change in entropy
disp('Change in internal energy = ',del_U,'kJ')
disp('Change in enthalpy = ',del_H,'kJ')
disp('Change in entropy = ',del_s,'kJ/K')
