//Example 7.4
//Estimate the entropy change of the universe
clear 
clc
 m = 0.5; //[kg]
 Cp = 0.45; //[kJ/kg K]
 T1 = 273 + 120; //[K]
 T2 = 273 + 10; //[K]
 // Case 1 : Iron block is placed in lake at 10°C
 del_s_system = m*Cp*log(T2/T1); //[kJ/kg]
 Q = m*Cp*(T1-T2); //[kJ]
 del_s_surr = Q/T2; //[kJ/kg K]
 del_s_1 = del_s_system + del_s_surr; //[kJ/kg K]
 disp('Entropy change when iron block is placed in lake at 10°C',del_s_1,'kJ/kg K')
 // Case 2: Iron block is dropped in lake from 150 m
 g = 9.8; //[m/s^2] Acceleration due to gravity
 h = 150; //[m]
 Q1 = m*g*h; //[kJ/kg K]
 del_s_2 = Q1/T2; //[kJ/kg K]
 disp('Entropy change when iron block is dropped from 150 m',del_s_2,'kJ/kg K')
 // Case 3: Two iron blocks are joined together
 Tf = (T1 + T2)/2; //[K] Final temperature when both blocks are joined
 del_s_block1 = m*Cp*log(Tf/T1); //[kJ/kg K]
 del_s_block2 = m*Cp*log(Tf/T2); //[kJ/kg K]
 del_s_3 = del_s_block1 + del_s_block2; //[kJ/kg K] Entropy change when two blocks are joined
 disp('Entropy change when two blocks are joined',del_s_3,'kJ/kg K' )
//Value of del_s_1 vary due to round off error