//Example 6.7
// Evaluate the power required to remove heat in 5 hours
clear
clc
m = 150; //[kg]
ti = 10; //[°C] Initial temperature
tf = -2; //[°C]  Freezing point
T1 = 35 + 273; //[K]  Ambient temperature
t2 = -5; //[°C] Temperature required in celsius
T2 = 273 - 5; //[K] Temperature required in kelvin
Cp1 = 3.2; //[kJ/kg K] Specific heat of fish above freezing point
Cp2 = 1.699; //[kJ/kg K] Specific heat of fish below freezing point
hfg = 232; //[kJ/kg] Latent heat of fusion
COP_R_Rev = T2/(T1 - T2); 
COP = 0.4*COP_R_Rev; // Actual COP
Q2 = m*[Cp1 *(ti - tf)+ hfg + Cp2*(tf - t2)]; //[kJ]
Wnet_in = Q2/COP; //[kJ]
del_t = 5*3600; //[s]
W = Wnet_in/del_t; //[kW]
disp('Power required to remove heat in 5 hours = ',W,'kW')
