//Example 12.4
//Determine the steam flow rate
clear
clc
//From steam tables at 1.5 bar and 0.85 dry
Tsat = 111.37;//[°C]
hfg = 2265.5; //[kJ/kg]
x = 0.85;
T1 = 273 + 111.37; //[K] Generator temperature
T2 = 273 + 25; //[K] Codenser or absorber temperature
Tr = 273 - 20; //[K]  Evaporator temperature
Load = (10*14000)/3600; //[kJ/s]
 COP_max = [(T1 - T2)*Tr]/[(T2 - Tr)*T1];
 Q_E = Load/COP_max; //[kW] Refrigerating effect
 // Q = m*(h2 - h1), where h2 - h1 = hf - x*hfg - hf  = h2_h1
 h2_h1= x*hfg;//[kJ/kg]  Heat transfered by 1 kg steam on condensation
 m = Q_E/h2_h1;//[kg/s] steam flow rate
 disp('The rate of steam flow =',m,'kg/s')
