//Example 12.2
//Calculate following question on gas refrigerating system
clear
clc
T1 = 273 - 12; //[K]  Temperature at inlet to compressor
T3 = 273 + 27; //[K]  Temperature at inlet to turbine
rp = 5; // pressure ratio (rp) = p2/p1
gama = 1.4; 
Cp = 1.005;
R = 0.287;
p1 = 100; //[kPa]
Load = (10*14000)/3600; //[kJ/h]  1 ton = 14000 kJ/s
T2 = T1*[(rp)^( (gama -1)/gama )]; //[K]
T4 = T3*[(1/rp)^( (gama -1)/gama )]; //[K] since p4 = p1 and p3 = p2
RE = Cp*(T1 - T4);//[kJ/kg]  Refrigerating effect
W_net_in = Cp*[(T2 - T1) - (T3 - T4)]; //[kJ/kg] Net work input
//(i) Compute COP
COP = RE/W_net_in;
disp('COP = ',COP)
//(ii) Compute air flow rate in kg/s 
m = Load/RE; //[kg/s] Mass flow rate of refrigerant
disp('Air flow rate = ',m,'kg/s')
//(iii) Compute volume rate entering compressor in m^3/s
vi = (R*T1)/p1; //[m^3/kg]
va = m*vi; //[m/s]
disp('Volume rate entering compressor = ',va,'m^3/s')
//(iv) Maximum and Minimum temperature
disp('Minimum temperature = ',T4-273,'°C')
disp('Maximum temperature = ',T2-273,'°C')
//The answer vary due to round off error
