//Example 11.4
//Calculate maximum temperature and percentage increase in efficiency
clear
clc
p1 = 103; //[kPa]
T1 = 300; //[K]
q1 = 700; //[kJ/kg]
rp = 5; // pressure ratio (rp) = p2/p1
eta_T = 0.75; //turbine efficiency
eta_c = 0.75; //compressor efficiency
Cp = 1.005;
gama = 1.4;
// Without regenerator
//For process1-2     T2_1/T1 = (p2/p1)^(gama -1/gama)
T2_1= T1*[(rp)^((gama -1)/gama)]; //[K]
T2 = [(T2_1 - T1)/eta_c] + T1; //[K] since eta_c = (T2_1 - T1)/(T2 - T1)
//(i) Compute maximum temperature in the cycle
T3 = (q1/Cp) + T2; //[K]   as q1 = Cp*(T3 - T2) max temp
disp('Maximum temperature in the cycle = ',T3,'K')
//For process 3-4   T3/T4_1 = (p2/p1)^(gama -1/gama)
T4_1 = T3/[(rp)^((gama -1)/gama)]; //[K]
T4 = T3 - [eta_T*(T3 - T4_1)]; //[K]
wT = Cp*(T3  - T4); //[kJ/kg]  turbine work
wc = Cp*(T2 - T1); //[kJ/kg]   work input of compressor
eta_cycle = [(wT - wc)/q1]*100; //[%]  cycle efficiency
//With regenerator
eta_r = 0.80; //regenerator effectiveness
T6 = eta_r*(T4 - T2) + T2; //[K]  eta_r = (T6 - T2)/(T4 - T2)
q1_1 = Cp*(T3 - T6); //[kJ/kg]
eta_cycle_1 = [(wT - wc)/q1_1]*100; //[%]
//(ii)Compute the percentage increase in efficiency of cycle due to regeneration
percent_inc = [(eta_cycle_1 - eta_cycle)/eta_cycle]*100; //[%]
disp('The percentage increase in efficiency of cycle due to regeneration = ',percent_inc,'%') 
//The answer vary due to round off error
