//Example 10.3
//Compute thermal efficiency of plant
clear
clc
s1 = 6.569; //[kJ/kg K]   s1 = s2 = s3 = s4

p = 3.5; //[bar]
// At p = 3.5 bar
sg = 6.9; //[kJ/kg K]
s2 = s1; //[kJ/kg K]
sf = 1.7275; //[kJ/kg K]
sfg = 5.213; //[kJ/kg K]
hf2 = 584; //[kJ/kg K]
hfg2 = 2148; //[kJ/kg K]
x2 = (s2 - sf)/sfg; 
h2 = hf2 + x2*hfg2; //[kJ/kg K]

p1 = 0.7; //[bar]
// At p1 = 0.7 bar
sf3 = 1.2; //[kJ/kg K]
sfg3 = 6.2; //[kJ/kg K]
hf3 = 384; //[kJ/kg]
hfg3 = 2278; //[kJ/kg]
s3 = s1; //[kJ/kg K]
x3 = (s3 - sf3)/sfg3; 
h3 = hf3 + x3*hfg3; //[kJ/kg]

p2 = 0.08; //[bar]
// At p2 = 0.08 bar
sf4 = 0.576; //[kJ/kg K]
sfg4 = 7.67; //[kJ/kg K]
hf4 = 168; //[kJ/kg]
hfg4 = 2406; //[kJ/kg]
s4 = s1; //[kJ/kg K]
x4 = (s4 - sf4)/sfg4; //[kJ/kg]
h4 = hf4 + x4*hfg4; //[kJ/kg]
h5 = 168; //[kJ/kg]  // h5 = hf4 at 0.08 bar
h6 = h5; //[kJ/kg K]
h7 = 375; //[kJ/kg K] at pressure 0.7 bar
h8 = h7; //[kJ/kg K]  at pressure 0.7 bar
h9 = 584.34; //[kJ/kg K]  at pressure 3.5 bar
h10 = h9; //[kJ/kg]  at pressure 3.5 bar
m1 = (h9 - h8)/(h2 - h8); //[kg]
h1 = 2993; //[kJ/kg K]
m2 = [(1 - m1)*(h7 - h6)]/(h3 - h6); //[kg]
wT = (h1 - h2) + (1 - m1)*(h2 - h3) + (1 - (m1 + m2) )*(h3 - h4); //[kJ/kg] work of turbine
q1 = h1 - h9; //[kJ/kg]  heat input
wp = 0; //pump work is negligible
eta = [(wT - wp)/q1]*100; //[%]
disp('Thermal efficiency of plant =',eta,'%')  
// The answer vary due to round off error
