//Example 9.7
//Estimate the increase in unavailable energy
clear
clc
m = 1; //[kg]
L = 1404; //[kJ/kg]  latent heat of vapourization of water
Tw = 273 + 300; //[K]
Tg_1 = 273 + 1500; //[K]  initial temperature of combustion gas
Tg_2 = 273 + 350; //[K]    final temperature of combustion gas
Cpg = 1.2; //[kJ/kg K]   specific heat of combustion gas at constant pressure
Ts = 273 + 25; //[K]
//Heat lost by combustion = Heat gained by water = Latent heat L
// mg*Cpg*del_T_g = mw*Cpw*del_T_w  = 1 * 1404 kJ/kg
mg = (m * L)/(Cpg *(Tg_1 - Tg_2) ); //[kg]  mass of gas
del_s_water = (m*L)/Tw; //[kJ/kg K]  entropy increase of water due to evaporation
function s = f(T)
    s = (mg*Cpg)/T;
endfunction
del_s_gas = intg(Tg_1, Tg_2, f); //[kJ/kg K] entropy decrease of combustion gas as it is cooled
del_s_total = del_s_water + del_s_gas; //[kJ/kg K]
E_loss = Ts * del_s_total; //[kJ]  loss in exergy
disp('Loss in (available energy) exergy = ',E_loss,'kJ' )
