//Example 9.4
//Determine Exergy of steam, Exergy destruction and Efficiency
clear
clc
m = 0.052; //[kg]
p1 = 12; //[bar]
T1 = 273 +350; //[K]
// At p1 and T1 value of u1, v1 and s1 are
u1 = 2872.7; //[kJ/kg]
v1 = 0.2345; //[m^3/kg]
s1 = 7.2139; //[kJ/kg K]
p2 = 3; //[bar]
T2 = 273 + 200; //[K] 
// At p2 and T2 value of u2, v2 and s2 are
u2 = 2651; //[kJ/kg ]
v2 = 0.7164; //[m^3/kg]
s2 = 7.313; //[kJ/kg K] 
p0 = 1; //[bar]
T0 = 273 + 25; //[K]
// At p0 and T0 value of u0, v0 and T0 are
u0 = 104.8;  //[kJ/kg]   
v0 = 0.00103; //[m^3/kg]   
s0 = 0.3672; //[kJ/kg K]
Q = 2.2; //[kJ]  Heat lost to the surrounding
// (i) Determine the exergy of steam at the initial and final states
X1 = m*[ (u1 - u0) - T0*(s1 - s0) + p0*100*(v1 - v0) ]; //[kJ]  Exergy of steam at state 1
X2 = m*[ (u2 - u0) - T0*(s2 - s0) + p0*100*(v2 - v0)]; //[kJ]   Exergy of steam at state 2
disp('Exergy of steam at state 1 = ',X1,'kJ')
disp('Exergy of steam at state 2 = ', X2, 'kJ')
//(ii) Determine the exergy destruction
del_X = (X1-X2); //[kJ]
del_s_sys = m*(s2 - s1); //[kJ/K]
del_s_surr = Q/T0; //[kJ/K]
s_gen = del_s_sys + del_s_surr; //[kJ/K]
X_destroyed = T0 * s_gen; //[kJ]   exergy destroyed
disp('Exergy destroyed =',X_destroyed,'kJ')
//(iii) Determine the second law efficiency
X_expended = del_X; //[kJ]
eta_pi = (1 - (X_destroyed/X_expended) )*100; //[%]  efficiency
// work potential of the steam is called second law efficiency
disp(' Therefore, the work potential of the steam is ', eta_pi,'%')
// The answer vary due to round off error
