//Example 9.3
//Calculate Availability at state 1 and 2, Irreversibility and Second law efficiency
clear
clc
p1 = 500; //[kPa]
p2 = 100; //[kPa]
p0 = 100; //[kPa]
V1 = 150; //[m/s]
V2 = 70;  //[m/s]
T1 = 400; //[K]
T2 = 300; //[K]
T0 = 290; //[K]
Cp = 1.005; //[kJ/kg K]
R = 0.287; 
//(i) Calculate  the availability at states 1 and 2
//psi_1 = Cp*(T1 - T0) - T0*(s1 - s2) + V1^2/2
psi_1 = Cp*(T1 - T0) - T0*[R*log(p0/p1) - Cp*log(T0/T1)] + V1^2/(2*1000); //[kJ]
disp('Availability at state 1 = ',psi_1,'kJ')
//psi_2 = Cp*(T2 - T0) - T0*(s2 - s0) + V2^2/2
psi_2 = Cp*(T2 - T0) - T0*[R*log(p0/p2) - Cp*log(T0/T2)] + V2^2/(2*1000); //[kJ]
disp('Availability at state 2 = ',psi_2,'kJ')
//(ii) Calculate irreversibility or energy destruction
// W_act = (h1 - h2) + (V1^2 - V2^2)/2
W_act = Cp*(T1 - T2) + (V1^2 - V2^2)/(2*1000); //[kJ] Actual work output of turbine
//W_max = (h1 - h2) - T0*(s1 - s2) +(V1^2 - V2^2)/2 = psi_1 - psi_2
W_max = psi_1 - psi_2; //[kJ] Maximum work output of turbine
I = W_max - W_act; //[kJ]  Irreversibility
disp('Irreversibility = ',I,' kJ ' )
//(iii) Calculate the second-law efficiency
eta_pi = (W_act/W_max)*100; //[%]
disp('The second-law efficiency = ',eta_pi,' % ')
//The answer vary due to round off error
