//Example 7.8
//Find isentropic efficiency of turbine and mass flow rate of steam
clear
clc
p1 = 50; //[bar]
T1 = 600; //[°C]
h1 = 3666.5; //[kJ/kg] From superheated steam tables at p1 and T1
s1 = 7.259; //[kJ/kg K] From superheated steam tables at p1 and T1
p2 = 0.5; //[bar]
T2 = 150; //[°C]
h2 = 2780.2; //[kJ/kg s] From superheated steam tables at p2 and T2
s2 = 7.9413; //[kJ/kg K] From superheated steam tables at p2 and T2
//From saturated steam tables at p2 = 0.5 bar 
sf = 1.091; //[kJ/kg K]  
sg = 7.593; //[kJ/kg K]  
sfg = 6.502; //[kJ/kg K]
hf = 340.5; //[kJ/kg]
hfg = 2304.7; //[kJ/kg]
s2_1 = s1; //Entropy remains constant for isentropic process
x2_1 = (s2_1 - sf)/sfg; 
h2_1 = hf + x2_1 * hfg; //[kJ/kg]
//(i) Find isentropic efficiency of the turbine
eta_T = ((h1 - h2)/(h1 - h2_1))*100;  
disp('Isentropic efficiency of turbine = ' , eta_T , '%')
// (ii) Find the mass flow rate of steam flowing through the turbine
W_out = 5*1000; //[kW] Power output of the turbine
m = W_out/(h1-h2); //[kg/s] Mass flow rate of steam
disp('Mass flow rate of steam flowing through the turbine = ', m , 'kg/s' )
//The answer vary due to round off error
