//Example 5.7
//Determine mass flow rate of the cooling water
clear
clc
//For a heat exchanger, SFEE is m1*h1+m2*h2 = m3*h3+m4*h4
//For steady flow, mass flow rates are equal so eq is m_air(h1-h3)=m_water(h4-h2)
m_air = 1; //[kg/s]
h1 = 373; //[kJ/kg]  from tables of ideal gas properties of air at 373 K
h3 = 313; //[kJ/kg]  from tables of ideal gas properties of air at 313 K
h2 = 125.79; //[kJ/kg]  from saturated water temperature table at 30°C
h4 = 167.53; //[kJ/kg]  from saturated water temperature tables at 40°C
m_water = (m_air*(h1-h3))/(h4-h2); //[kg/s] 
disp('Mass flow rate of cooling water = ',m_water,'kg/s')
