//Example 5.6
//Determine the mass flow rate of air and temperature of air at the exit of diffuser
clear
clc
T1 = 273 + 15; //[K]
V1 = 215; //[m/s]
p1 = 90; //[kPa]
R = 0.287;   
v1 = (R*T1)/p1; //[m^3/kg]
A1 = 0.38; //[m^2]
//(i) Determine mass flow rate of air 
m = (A1*V1)/v1; //[kg/s]
disp('Mass flow rate of the air = ',m,'kg/s')
//(ii)Determine the temperature of air at the exit of diffuser
//For diffuser, mass flow rate remains constant in steady flow so final equation is [h1 + V1^2/2] = [h2 +V2^2/2]
V2 = 0; //velocity of air leaving the diffuser is very small to vel at inlet
h1 = 288; //[kJ/kg]  from tables of ideal gas properties of air 
h2 = h1 + V1^2/(2*1000) - V2^2/(2*1000);
disp('h2 = ',h2, 'kJ/kg')
disp('Temperature of air at the exit of diffuser is equal to Temperature corresponding to the enthalpy value of h2 from tables')
T2 = 39; //[°C] From tables of ideal gas properties of air, temperature corresponding to h2
disp('Temperature of air at the exit of diffuser = ', T2 ,'°C')
// The answer vary due to round off error
