//Example 4.7
//Determine the quality of steam in the main
clear
clc
h3 = 2768.8; //[kJ/kg]   From superheated steam tables, at 2 bar and 150°C 
h2 = h3; //enthalpy before throttling = enthalpy after throttling
hf2 = 798.65; //[kJ/kg]   From saturated steam table at 12 bar
hfg2 = 1986.2; //[kJ/kg]  From saturated steam table at 12 bar
// h2 = hf2 + x2*hfg2
x2 = (h2-hf2)/hfg2;  
V = 0.2*10^-3; //[m^3]
v = 0.001029; //[m^3/kg]   From saturated steam table at 80°C (v = vf = 0.001029)
m1 = V/v; //[kg]
m2 = 2; //[kg]   Mass of steam condensed after throttling
x1 = (x2 *m2)/(m1 +m2);  
disp('x1 = ', x1)
