//Example 4.1
//Determine specific volume, temperature, enthalpy, entropy, internal energy
clear
clc
//(i) Determine specific volume
V = 50*10^-3 //[m^3]
m = 5; //[kg]
v = V/m; //[m^3/kg]    specific volume
disp('Specific volume v, = ', v , 'm^3/kg')
//(ii) Determine temperature 
//From steam table at 150 kPa
vf = 0.00109; //[m^3/kg]
vg = 0.3749; //[m^3/kg]
t = 151.86; //°C    since vf<v<vg , water is in saturated mixture region, the temperature must be the saturated temperature at pressure 150 kPa
disp('Temperature = ' , t , '°C')
//(iii) Determine enthalpy
vfg = vg - vf;  //[m^3/kg]
x = (v-vf)/vfg; 
// At 500 kPa
hf = 640.23;  //[kJ/kg] //value of hf is mentioned wrong in book
hfg = 2108;  //[kJ/kg]
sf = 1.8607; //[kJ/kg K]  
sfg = 6.821; //[kJ/kg K]  
h = hf + x*hfg; //[kJ/kg]
disp('Enthalpy, h  = ', h ,'kJ/kg') 
//(iv) Determine entropy
s = sf +x*sfg; //[kJ/kg K]
disp('Entropy, s = ', s , 'kJ/kg K')
//(v) Determine internal energy
p = 150; //[kPa]
v1 = 0.01;
u = h - p*v1; // [kJ/kg]
disp('Internal energy, u = ', u ,'kJ/kg')
//The answer vary due to round off error
