//Example 3.8
//Estimate the work done for given conditions
clear
clc
P1 = 250; //[kPa] 
m = 1; //[kg]
V1 = 0.035; //[m^3]
V2 = 0.09;  //[m^3] 
//(i) Gas expands to 0.09 m^3 when pressure is constant
function W = f(V)
    W = P1;
endfunction
w = intg(V1, V2, f); //[kJ]
disp('Work done in isobaric process = ', w ,'kJ' )
//(ii) Gas expands isothermally when the weights are removed
W1 = P1*V1*log(V2/V1); //[kJ]
disp('Work done in isothermal process = ', W1, 'kJ')
//(iii) Expansion follows P*(V^1.4) = Constant
n = 1.4;
P2 = P1*(V1/V2)^n; //[kPa]
W2 = (P1*V1-P2*V2)/(n-1); //[kJ]
disp('Work done in polytropic process = ' , W2 , 'kJ')
//The answer vary due to round off error
