//Example 14.3
// Estimate Partial pressure, Specific humidity, Enthalpy and Mass
clear
clc
T = 273 + 27; //[K]
Va = 100; //[m^3] Volume of dry air
Vw = Va; //[m^3]  Volume of water vapor
p = 101.325; //[kPa]
φ = 0.60; //Relative humidity
//From steam tables for water at 27°C 
p_sat = 3.422; //[kPa]
hfg = 2551; //[kJ/kg]
//(i) Estimate partial pressure of dry air
pw = φ*p_sat; //[kPa]
pa = p - pw; //[kPa]
disp('Partial pressure of dry air = ',pa,'kPa')
//(ii) Estimate specific humidity
ω = 0.622*pw/(p - pw); //[kg vapor/kg of dry air] Specific humidity
disp('Specific humidity = ',ω,'kg vapor/kg of dry air')
//(iii) Estimate enthalpy of dry air
//Enthalpy of air-vapor mixture is Gh = Gha + m*hw or h = ha + ω hw
ha = 1.005* 27; //[kJ/kg]
hw = hfg; //[kJ/kg]
h = ha + ω*hw;//[kJ/kg] Enthalpy of air-vapor mixture
disp('Enthalpy of dry air = ',ha,'kJ/kg')
//(iv) Estimate mass of dry air and water vapor
Ra = 0.287; 
ma = (pa*Va)/(Ra*T);//[kg] Mass of dry air
Rw = 0.4619;
mw = (pw*Vw)/(Rw*T); //[kg] Mass of water vapor
disp('Mass of dry air = ',ma,'kg')
disp('Mass of water vapor = ',mw,'kg')
