//Example 12.5
//Determine COP and air mass flow rate and power 
clear
clc
T1 = 273 +5; //[K]
T3 = 273 + 40; //[K]
 p1 = 100; //[kPa]
 p2 = 250; //[kPa]
 eta_comp = 0.80; // Isentropic efficiency of compressor
 eta_Turbine = 0.80; // Isentropic efficiency of turbine
 Cp = 1.005; //[kJ/kg K]
 Load = (5*14000)/3600; //[kJ/s]
 gama = 1.4;
 T2 = T1*[(p2/p1)^( (gama -1)/gama )]; //[K] For process 1-2
 p3 = p2; //[kPa]
 p4 =p1; //[kPa]
 T4 = T3/[(p3/p4)^( (gama -1)/gama )]; //[K]
 T2_1 = [(T2 - T1)/eta_comp] + T1; //[K]
 T4_1 = T3 - [eta_Turbine*(T3 - T4)]; //[K]
 //(i) Determine COP
 Q2 = Cp*(T1 - T4_1); //[kJ/kg]
 W_net_in = Cp*[(T2_1 - T1) - (T3 - T4_1)];//[kJ/kg]
 COP = Q2/W_net_in;
 disp('COP = ',COP)
 //(ii) Determine air mass flow rate
 m = Load/Q2; //[kg/s]
 disp('Air mass flow rate =',m,'kg/s')
 //(iii) Determine driving power required
 P = m*W_net_in;//[kW]
 disp('Driving power required = ',P,'kW')
