//Example 12.3
// Calculate following question on food freezing system
clear
clc
// From saturated tables of refrigerant R-12
//At temperature -35°C
T1 = 273 - 35;//[K]
h1 = 175; //[kJ/kg]    h1 = hg
v1 = 0.1954; //[m^3/kg]
s1 = 0.72; //[kJ/kg K]  s1 = sg
// At temperature 25°C
T2 = 273 + 25; //[K]
h2 = 197.73; //[kJ/kg]  h2 = hg
s2 = 0.6868; //[kJ/kg K] s2 = sg
h3 = 59.7; //[kJ/kg K]  h3 = hf
del_T1 = 5; //Tsup - Tsat
Cpg = 1.235; //[kJ/kg K]
Cpl = 0.733; //[kJ/kg K]
eta_v = 0.80; //volumetric efficiency
N = 1500; //[rpm]
n = 6; //six cylinders
Load = (20*14000)/3600; //[kJ/s]
h1_1 = h1 + Cpg*(del_T1); //[kJ/kg]
T1_1 = T1 + 5;//[K]
 s1_1 = s1 + Cpg*log(T1_1/T1); //[kJ/kg K]
 s2_1 =s1_1;//[kJ/kg K]  s2_1 = s2 + Cpg*log(T2_1/T2)
 L_T2_1 = [(s2_1 - s2)/Cpg] + log(T2);
 T2_1 = exp(L_T2_1); //[K]
 // Entahlpy of subcooled liquid refrigerant  = h3_1 = h3 + Cpl*(T3 - T3_1) 
 h3_1 = h3 - Cpl*(4); //[kJ/kg] 
 h2_1 = h2 + Cpg*(T2_1 - T2); //[kJ/kg]
 //(i) Determine refrigerating effect
 RE = h1 - h3_1; //[kJ/kg]  Refrigerating effect, h1 - h1 = h1 - h3_1
 disp('Refrigerating effect = ',RE,'kJ/kg')
 h4 = h3_1;//[kJ/kg]
 //(ii) Determine flow rate of R-12
 m = Load/RE; //[kg/s]
 disp('Flow rate of R-12 =',m,'kg/s')
 //(iii) Determine cylinder dimension 
 va = m*v1; //[m^3/s]
 vs = (va/eta_v)*60; //[m^3/min]
 // Swept volume vs = (pi/4)*d^2*L*N*n, L = d
 d = [(vs *4)/(%pi *N*n)]^(1/3);
  disp('Length and diameter of cylinder are same')
  disp('Length = ',d,'m')
  disp('Diameter =',d,'m')
 //(iv) Determine the power required to drive the compressor
  P = m*(h2_1 - h1_1); //[kW]
  disp('Power required to drive the compressor =',P,'kW')
  //(v) Determine COP
 COP = (h1 - h4)/(h2_1 - h1_1);
 disp('COP =',COP)
 // The answer for question (iv) and (v) are provided wrong in textbook due to calculation mistake in h2_1
