//Example 11.3
// Calculate following question on Brayton cycle gas turbine plant
clear
clc
p1 = 1; //[bar]
T1 = 298; //[K]
rp = 8; //pressure ratio rp = p2/p1
eta_T = 0.85; //turbine efficiency
eta_c = 0.85; //compressor efficiency
// For process1-2 T2_1/T1 = (p2/p1)^((gama-1)/gama)
gama = 1.4
T2_1 = T1*[(rp)^((gama-1)/gama)];//[K]
T3 = 273+950;//[K]  maximum temperature
// For process 3-4  T4_1/T3 = (p4/p3)^((gama-1)/gama) & p4/p3 = p1/p2 = 1/rp
T4_1 = T3*[(1/rp)^((gama -1)/gama)]; //[K]
T2 = [(T2_1 - T1)/eta_c]+T1; //[K]  eta_c = (T2_1 - T1)/(T2 - T1)
Cp = 1.005; 
//Compute compressor work per kg of air
wc = Cp*(T2 - T1); //[kJ/kg]  work input to compressor
//Compute turbine exhaust temperature
T4 = T3 - eta_T*(T3 - T4_1);//[K]
// Compute turbine work per kg of air
wT = Cp*(T3 - T4); //[kJ/kg]  work output of turbine
//Compute heat supplied per kg of air
 Q1 = Cp*(T3 - T2); //[kJ/kg]
 // Compute cycle efficiency
 eta_cycle = [(wT - wc)/Q1]*100;
 //Compute the black work ratio
 B_wr = (wc/wT)*100; //[%] black work ratio 
 disp('The turbine work per kg of air = ',wT,'kJ/kg')  //(i)
 disp('The compressor work per kg of air = ',wc,'kJ/kg') //(ii)
 disp('Cycle efficiency = ',eta_cycle,'%')  //(iii)
 disp('Heat supplied per kg of air = ',Q1,'kJ/kg') //(iv)
 disp('Turbine exhaust temperature = ',T4,'K') //(v)
 disp('Black work ratio = ',B_wr,'%')  //(vi)
