//Example 10.6
//Calculate Work, Efficiency of cycle, Steam rate and Isentropic efficiency
clear
clc
p1 = 2.5; //[bar]
// From steam tables  at p1 = 2.5 bar
h1 = 2716.9; //[kJ/kg]
sg = 7.052; //[kJ/kg K]
s1 = sg; //[kJ/kg]
s2 = s1;
hf = 125.77; //[kJ/kg]   at 30°C
hfg = 2430.5; //[kJ/kg]   at 30°C
x = 0.85; //given in question
h2 = hf + x*hfg; //[kJ/kg]
h3 = hf; //[kJ/kg]  at 30°C
p2 = 0.0562; //[bar]  Saturation pressure at 30°C
vf = 1.006*10^-3; //[m^3/kg]   value of vf at  p2 = 0.0562 bar at 30°C
wp = vf*(p1 - p2); //[kJ/kg]   // wp = h4 - h3 = vf*(p1 - p2)
 s2_dash = s1;
 sf = 0.4369; //[kJ/kg K]  at 30°C
 sfg = 8.0164; //[kJ/kg K]  at 30°C
 x2_dash = (s2_dash - sf)/sfg; 
 h2_dash = hf + x2_dash*hfg; //[kJ/kg K]
 h4 = wp + h3; //[kJ/kg K]
 q1 = h1 - h4; //[kJ/kg]
 wT = h1 - h2; //[kJ/kg]
 //(i) Estimate w_net_out
 w_net_out = wT - wp; //[kJ/kg K]
 disp('w_net_out = ',w_net_out,'kJ/kg')
 //(ii) Estimate eta_cycle
 eta_cycle = (w_net_out/q1)*100; //[%]
 disp('eta_cycle = ',eta_cycle,'%')
 //(iii) Estimate steam rate
 St_rate = 3600/w_net_out; //[kg/kW h]
 disp('Steam rate = ',St_rate,'kJ/kW h')
 //(iv) Estimate isentropic efficiency of turbine
 eta_isentropic = [(h1 - h2)/(h1 - h2_dash)]*100; //[%] 
 disp('Isentropic efficiency of turbine = ',eta_isentropic,'%')
