//Example 10.4
//Calculate following question on regenerative cycle
clear
clc
//From steam tables at 50 bar and 350°C
h1 = 3068; //[kJ/kg]
s1 = 6.45; //[kJ/kg K]   s1 = s2 = s3
s2 = s1;
// At 7 bar
sg = 6.708; //[kJ/kg K]
hf2 = 697.22; //[kJ/kg]
hfg2 = 2066.3; //[kJ/kg]
sf2 = 1.992; //[kJ/kg K]
sfg2 = sg - sf2; //[kJ/kg K]
x2 = (s2 - sf2)/sfg2; 
h2 = hf2 + x2*hfg2;
//At 0.5 bar
sf3 = 1.091; //[kJ/kg K]
sg3 = 7.593; //[kJ/kg K]
sfg3 = 6.502; //[kJ/kg K]
s3 = s1; //[kJ/kg K]
x3 = (s3 - sf3)/sfg3;  
hf3 = 340.49; //[kJ/kg]
hfg3 = 2305.4; //[kJ/kg]
h3 = hf3 + x3*hfg3; //[kJ/kg]
h4 = hf3; //[kJ/kg] at 0.5 bar
h5 = h4; //[kJ/kg]
s4 = sf3; // at 0.5 bar
h6 = 697.22; // at 7 bar
h7 = h6; //[kJ/kg]
// Energy balance for heater => m1*h2 + (1 - m1)*h5 = h6
m1 = (384.39 - h5)/(h2 - h5); //[kg]
q1_with_reg = h1 - h6; //[kJ/kg]  with regeneration
q1_without_reg= h1 - h4; //[kJ/kg]  without regeneration
wT_with_reg = (h1 - h2) + (1 - m1)*(h2 - h3); //[kJ/kg]   with regeneration
wT_without_reg = h1 - h3; //[kJ/kg]   without regeneration
s7 = sf2;
//(i) Find efficiency of cycle
eta_with_reg = (wT_with_reg/q1_with_reg)*100; //[%]  Efficiency of cycle with regeneration
disp('Efficiency of cycle with regeneration = ',eta_with_reg,'%')
eta_without_reg = (wT_without_reg/q1_without_reg)*100; //[%]  Efficiency of cycle without regeneration
disp('Efficiency of cycle without  regeneration = ',eta_without_reg,'%')
// (ii)Find steam rate
S_rate_with_reg = 3600/wT_with_reg; //[kg/kW h]  Steam rate with regeneration
disp('Steam rate with regeneration = ',S_rate_with_reg,'kg/kW h')
S_rate_without_reg = 3600/wT_without_reg; //[kg/kW h] Steam rate without regeneration
disp('Steam rate without  regeneration = ',S_rate_without_reg,'kg/kW h')
//(iii)Find the mean temperature of the heat addition 
Tm_with_reg = (h1 - h7)/(s1 - s7); //[K]  with regeneration
disp('Mean temperature of heat addition with regeneration = ',Tm_with_reg,'K')
Tm_without_reg = (h1 - h4)/(s1 - s4); //[K]  without regeneration
disp('Mean temperature of heat addition without regeneration = ',Tm_without_reg,'K')
//(iv)Find increase in Tm and steam rate with regeneration
del_Tm = Tm_with_reg - Tm_without_reg; //[°C]  Increase in Tm with regeneration
disp('Increase in Tm with regeneration = ',del_Tm,'K')
S_rate_inc = S_rate_with_reg - S_rate_without_reg; //[kg/kW h]  Increase in steam rate with regeneration
disp('Increase in steam rate with regeneration = ',S_rate_inc,'kg/kW h')
// The answer vary due to round off error
