//Example 10.2
//Estimate reheat pressure and efficiency and steam rate
clear
clc
p1 = 150; // [bar]
T1 = 550; //[°C]
h1 = 3448; //[kJ/kg] At p1 and T1
h2 = 2740; //[kJ/kg] From Mollier chart
//At state 4
p4 = 0.1; //[bar]
x4 = 0.95;
sf4 = 0.1; //[bar]
sfg4 = 7.602; //[kJ/kg K]
hf4 = 191.83; //[kJ/kg]
hfg4 = 2392.8; //[kJ/kg K]
s4 = sf4 + x4*sfg4; //[kJ/kg K]
// At state 3
T3 = 550;//[°C]
s3 = s4; //[kJ/kg K]
p3 = 13; //[bar] By interpolation  //(i)
h3 = 3500; //[kJ/kg]
sg = 5.3; //[kJ/kg K]
h4 = hf4 + x4*hfg4; //[kJ/kg K]
h5 = hf4; //[kJ/kg K]
v5 = 0.001; //[m^3/kg]
wp = v5*(p1 - p4); //[kJ/kg]
h6 = wp+h5; //[kJ/kg]
wT = (h1 - h2) + (h3 - h4); //[kJ/kg]
w_net_out = wT - wp; //[kJ/kg]
q1 = (h1 - h6) + (h3 - h2); //[kJ/kg]
eta_cycle = [(wT - wp)/q1]*100; //[%]  //(ii)
Steam_rate = 3600/w_net_out; //[kg/kW h]   //(iii)
disp('Reheat pressure = ', p3 ,'bar')
disp('eta_cycle = ',eta_cycle,'%')
disp('Steam rate = ', Steam_rate ,'kg/kW h')
//The answer vary due to round off error
