// Scilab Code for 8.18
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex8_18.txt")
T = 25+273  ;   // Temperature in Kelvin 
v = 1.00187*10^(-3) ; // Specefic volume of water in m^3 /Kg
r = 10^(-6) ;   // Average radius of the droplets in m
N =  3*v/(4*3.1417*r^3)  ;   // Number of droplets per Kg
disp(" Number of droplets per Kg is  ;",N)
A = 4*%pi*(r^2)*N  ; // Total Surface area of droplets in m^2 per Kg
disp(" Total Surface area of droplets in 10^3 m^2 per Kg is ;",A/10^(3))
dsigma_dT = -0.152*10^(-3)  ;  // Rate of change of Surface tensionwith Tempearure in N m^(-1) K^(-1)
Q_T = -T*(dsigma_dT)*A ; // Heat Transferred to the droplet in J/Kg
disp(" Heat Transferred to the droplet in J/Kg is ;",Q_T)


/* Result 

   2.392D+14

  Number of droplets per Kg is  ;

   3.0055073

  Total Surface area of droplets in 10^3 m^2 per Kg is ;

   136.13746

  Heat Transferred to the droplet in J/Kg is ;

   */
