// Scilab Code for 5.12
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex5_12.txt")
R = 8.31  ;  //  Gas Constant in J mol^(-1) K^(-1)
V2_V1 = 1/2 ; //  Ration of final and initial  Volume
T1 = 273 ;   //  temperature in K in state 1
T2 = 273 ;   //  temperature in K in state 2
p3_p2 = 1/2 ; // Ratio of pressure in state 3  to state 2
Y = 1.4 ;   //  Adiabatic constant
T3 = ((p3_p2)^(1-1/Y))*T2 ;
// (a)  Net work done by the gas 
W_isothermal = R*T1*log(V2_V1) ;  // Net work done by the gas in J
disp(" (a) Net work done by the gas in J is ;",W_isothermal)
disp(" Temperature in State 3 , T3 = ;",T3)
W_adiabatic = R*(T1-T3)/(Y-1);  // Net work done by the gas in J in adiabatic process is
disp("work done by the gas in J in adiabatic process is ;",W_adiabatic)
disp(" Net work done by the gas in J is ;",W_adiabatic + W_isothermal)
// (b) Net heat flowing into the gas
disp(" (b) Net Heat flowing into the gas in J during isothermal process is ;",W_isothermal)
// (c) Change in internal energy
disp( "(c) Change in internal energy is  ;",W_adiabatic)
// (d) Final Temperature
disp("(d) Final Temperature in Kelvin ;",T3)

/* Result 

   223.95155

  Temperature in State 3 , T3 = ;

   1018.9815

 work done by the gas in J in adiabatic process is ;

  -553.51298

  Net work done by the gas in J is ;

  -1572.4945

  (b) Net Heat flowing into the gas in J during isothermal process is ;

   1018.9815

 (c) Change in internal energy is  ;

   223.95155

 (d) Final Temperature in Kelvin ;
 
 "Answer vaies due to round off error"

   */
