// Scilab Code for 4.17
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex4_17.txt")
C1 = 40*10^(-6)  ;   //   Thermo-electric Constant in V per degree C
C2 = -0.01*10^(-6) ;   // Thermo-electric Constant in V per degree C^2
E = 2.3*10^(-2) ;  // Thermo-emf in V

// defining the polynomial 
t_x = poly([-E C1 C2],'t','c');


// using root function to find the roots of the polynomial in terms
t = roots(t_x)    //   Temperature of the bath in degree C


disp(" Temperature of the bath in 10^2 degree C ;",round(t(2)/10^2))
disp(" Temperature of the bath in 10^2 degree C (It is not possible) ;", t(1)/10^2)

/* Result 

   7.  

  Temperature of the bath in 10^2 degree C ;

   33.038405  

  Temperature of the bath in 10^2 degree C (It is not possible) ;
  
  "Answer varies due to round off error"
   */
