// Scilab Code for 8.1
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex8_1.txt")
L = 79.6*4.186*10^(7) ;  // Latent heat of fusion in erg/g
T = 273.16  // Temperature in Kelvin
v_water = 1.0001 ; // Specefic volume of water in cm^3 /g
v_ice = 1.0908 ; // Specefic volume of ice in cm^3 /g
dp_dT = L/(T*(v_water-v_ice)) ;  //   dP/dT in dyne cm^(-2) K^(-1)
disp("dP/dT in dyne cm^(-2) K^(-1) is;",dp_dT)
dp = 2.026*10^(6)  // Change in pressure in dyne/cm^2
dT = dp*T*(v_water-v_ice)/L ; // Change in melting point in K
disp("Change in melting point in K is ;",dT)
disp("Change in melting point in degree C is ;",dT)
// The melting point decreases with pressure 
p = 1/0.0075  ;   //  Pressure in atm to lower the melting point by 1 degree C 
disp(" Pressure in atm to lower the melting point by 1 degree C  is ;",p)



/* Result
 
  -1.345D+08

 dP/dT in dyne cm^(-2) K^(-1) is;

  -0.0150644

 Change in melting point in K is ;

  -0.0150644

 Change in melting point in degree C is ;

   133.33333

  Pressure in atm to lower the melting point by 1 degree C  is ;

  */
