// Scilab Code for 7.4
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex7_4.txt")
m1 = 10 ;  // Mass of water in g
m2 = 30 ;  // Mass of water in g
L = 2.26*10^6 ;  // Latent heat of steam in J/Kg
c = 1 ; // specefic heta in cal g^(-1) K^(-1)
T1 = 60 + 273 ;   // Temperature in K
T3 = 20 + 273 ;   // Temperature in K
t = (m1*c*T1 + m2*c*T3)/(m1*c + m2*c) ;  // Temperature of mixing in K
disp(" Temperature of mixing in K is ;",t)
disp(" Temperature of mixing in degree C is ;",t-273)
del_S1 = m1*c*log(t/T1) ;  // Change in Entropy when temperature changes from 60 to 30 in cal/K
disp(" Change in Entropy when temperature changes from 60 to 30 in cal/K is ;",del_S1)
del_S2 = m2*c*log(t/T3) ; // Change in Entropy when temperature changes from 20 to 30 in cal/K
disp(" Change in Entropy when temperature changes from 20 to 30 in cal/K is ;",del_S2)
disp(" Total Increase in Entropy in cal/K  is ;",del_S1+del_S2)


/* Result

 
   303.

  Temperature of mixing in K is ;

   30.

  Temperature of mixing in degree C is ;

  -0.9440968

  Change in Entropy when temperature changes from 60 to 30 in cal/K is ;

   1.0068059

  Change in Entropy when temperature changes from 20 to 30 in cal/K is ;

   0.0627091

  Total Increase in Entropy in cal/K  is ;
  

   */
