// Scilab Code for 3.5
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex3_5.txt")
a = 13.2*10^(-2) ;  //  Van der Walls gas Constant "a" in N m^4 mol^(-2)
b = 31.2*10^(-6) ;  //  Van der Walls gas Constant "b" in  m^3 mol^(-1)
R = 8.31 ;  //  Gas Constant in J mol^(-1) K^(-1)
Cp = 3.4*R ;  //  Specefic heat at constant pressure 
T = 27 + 273 ;  // Temperature in Kelvin
delta_p = 50*1.013*10^(5) ;   //  Pressure difference in N m^(-2) 
// p1-p2 = delta_p
delta_T = (delta_p/Cp)*(((2*a)/(R*T))-b) ;   // Drop in Temperature in Kelvin 
disp(" Drop in Temperature in Kelvin ;",delta_T) 

/* Result 


   13.390593

  Drop in Temperature in Kelvin ;
  
  "Answer vary due to round off error"
   */
   
