// Scilab Code for 2.23
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex2_23.txt")
rho = 8.9*10^(-2) ;   //  density in Kg m^(-3)
lambda = 2*10^(-7) ;  // Mean free path in m 
Kb = 1.38*10^(-23)  ;   //  Boltzmann Constant in J/K
Na = 6.023*10^26 ;   // Avagadro Number per mol
m = 2/Na ;   //  mass of hydrogen in Kg
T = 273 ;   //  Temperature in Kelvin 
Vmean = sqrt(2.55*Kb*T/m) ;  // Average molecular speed in m/sec
disp( " Average molecular speed in m/sec is ;",Vmean)
eta = (1/3)*rho*Vmean*lambda ;  // Coefficient of viscosity of gas in Kg m^(-1) sec^(-1)
disp(," Coefficient of viscosity of gas in 10^(-5) Kg m^(-1) sec^(-1) is  ;",eta/10^(-5))

/* Result 


   1700.9141

  Average molecular speed in m/sec is ;

   1.0092091

  Coefficient of viscosity of gas in 10^(-5) Kg m^(-1) sec^(-1) is  ;
   
   */
