// Scilab Code for 2.13
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex2_13.txt")
rho = 1.29  ;     //   density of gas in Kgm^(-3)
Vmean = 460 ;     //   Average speed in m/sec
lambda = 6.4*10^(-8) ; //  Mean free path in m 
R = 8.31*10^3  ;  //  J Kmol^(-1) K^(-1)
M = 29   ;    //  Molar mass in Kg Kmol^(-1)
eta = (1/3)*rho*Vmean*lambda ;  // Coefficient of viscosity of Air  in Nsm^(-2)
disp(" Coefficient of viscosity of Air 10^(-5) Nsm^(-2) ;",eta/10^(-5))
Cv = (5/2)*R ;  //  specefic Heat in J Kmol^(-1) K^(-1)
disp(" specefic Heat in 10^(3) J Kmol^(-1) K^(-1) is ;",Cv/10^(3))
K = eta*Cv/M ;  // Thermal Conductivity of Air in J m^(-1) s^(-1) K^(-1)
disp(" Thermal Conductivity of Air in 10^(-3) J m^(-1) s^(-1) K^(-1) is ;",K/10^(-3))
D = (1/3)*Vmean*lambda ;  // Coefficient of diffusion  in  m^2 / sec
disp(" Coefficient of diffusion in 10^(-6) m^2 / sec  is ;",D/10^(-6))

/*  Result 

 
   1.26592

  Coefficient of viscosity of Air 10^(-5) Nsm^(-2) ;

   20.775

  specefic Heat in 10^(3) J Kmol^(-1) K^(-1) is ;

   9.068789

  Thermal Conductivity of Air in 10^(-3) J m^(-1) s^(-1) K^(-1) is ;

   9.8133333

  Coefficient of diffusion in 10^(-6) m^2 / sec  is ;
  
  "Answer vary due to roundoff error"
   
   */
