// Scilab Code for 11.6
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex11_6.txt")
b = 2.892*10^(-3)  ;   // Weins Constant in mK
lamda1 = 470*10^(-9) ;  // Wavelength in m
lamda2 = 14*10^(-6) ;  // Wavelength in m
T1 = b/lamda1 ;    //  Temperature for 1st Maxima in Kelvin
disp("(a) Temperature for 1st Maxima in 10^3 Kelvin is ;",T1/10^3)
sigma = 0.5672*10^(-7) ;   // Stephen's Constant in J m^(-2) K^(-4) s^(-1) 
c = 3*10^8 ;  // Speed of light in m/sec
u1 =(4*sigma*T1^4)/c ;  // Energy Density of solar radiation in J/m^3
disp(" Energy Density of solar radiation in J/m^3 is ;",u1)
disp("Pressure Density of solar radiation in N/m^2 is ;",u1/3)
T2 = b/lamda2 ;    //  Temperature for 1st Maxima in Kelvin
disp("(b) Temperature for 1st Maxima in 10^3 Kelvin is ;",T2/10^3)
u2 =(4*sigma*T2^4)/c ;  // Energy Density of solar radiation in J/m^3
disp(" Energy Density of solar radiation in 10^(-6)_J/m^3 is ;",u2/10^(-6))
disp("Pressure Density of solar radiation 10^(-6) in N/m^2 is ;",u2*10^(6)/3)



/* Result
 

   1.0841183

  Energy Density of solar radiation in J/m^3 is ;

   0.3613728

 Pressure Density of solar radiation in N/m^2 is ;

   0.2065714

 (b) Temperature for 1st Maxima in 10^3 Kelvin is ;

   1.3770699

  Energy Density of solar radiation in 10^(-6)_J/m^3 is ;

   0.4590233

 Pressure Density of solar radiation 10^(-6) in N/m^2 is ;
   */
