// Scilab Code for 5.15
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex5_15.txt")
pi = 5*10^(6) ;  // Pressure of a perfect gas in N/m^2
Vi = 0.2 ;   // Volume in m^3
Vf = 0.5 ;   // Volume in m^3
R = 8.314 ;  //  Gas Constant in J mol^(-1) K^(-1)
T = 300 ;  //  Temperature in Kelvin
n = (pi*Vi)/(R*T) ;  // Number of moles 
disp(" Number of moles is ;",n)
// (a) Final pressure at the end of the isothermal expansion 
pf = (pi*Vi)/Vf ;  // Final pressure at the end of the isothermal expansion in N/m^2
disp("(a) Final pressure at the end of the isothermal expansion in 10^6 N/m^2 is  ;",pf/10^6)
W_AB = n*R*T*log(Vf/Vi) ;  // Work done by the Gas from A to B in J
disp(" Work done by the Gas from A to B in 10^5 J is ;",W_AB/10^5)
// (b) Work done on the gas in going from B to C 
W_BC = pf*(Vf-Vi) ;  // Work done on the gas in going from B to C  in J
disp("(b) Work done on the gas in going from B to C  in 10^5 J is ;",W_BC/10^5)
disp("(c) Work done from C to a is 0")
W = W_AB - W_BC ;  // Total work done in the cycle by the gas 
disp(" Total work done in the cycle by the gas in 10^5 J  is ;",W/10^5)

/* Result 

   400.93016

  Number of moles is ;

   2.

 (a) Final pressure at the end of the isothermal expansion in 10^6 N/m^2 is  ;

   9.1629073

  Work done by the Gas from A to B in 10^5 J is ;

   6.

 (b) Work done on the gas in going from B to C  in 10^5 J is ;

 (c) Work done from C to a is 0

   3.1629073

  Total work done in the cycle by the gas in 10^5 J  is ;
  
  "Answers Varies due to round off error "

   */
