// Scilab Code for 3.4
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex3_4.txt")
Tc = 5.3  ;   // critical Temperature in Kelvin
Pc = 2.25*1.013*10^(5) ;  //  critical Pressure in N m^(-2)
R = 8.31 ;  //  Gas Constant in J mol^(-1) K^(-1)
Na = 6.023*10^23 ;   // Avagadro Number per mol
a = (27*R^2*Tc^2)/(64*Pc) ;   //  Van der Walls gas Constant "a" in N m^4 mol^(-2)
disp(" Van der Walls gas Constant a in  10^(-3)  N m^4 mol^(-2) is ;",a/10^(-3))
b = (R*Tc)/(8*Pc) ;   // Van der Walls gas Constant "b" in  m^3 mol^(-1)
disp(" Van der Walls gas Constant b in  10^(-5)  m^3 mol^(-1) is ;",b/10^(-5))
d = ((3*b)/(2*%pi*Na))^(1/3) ;  // Molecular diameter in m 
disp(" Molecular diameter in m  is ;",d)
/* Result 

 
   3.590423

  Van der Walls gas Constant a in  10^(-3)  N m^4 mol^(-2) is ;

   2.4154327

  Van der Walls gas Constant b in  10^(-5)  m^3 mol^(-1) is ;

   2.675D-10

  Molecular diameter in m  is ;
  
  "Answer vary due to round off error"
   
   */
