// Scilab Code for 12.8
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex12_8.txt")
ni = 6 ;   // Number of Particles
gi = 3 ;   // Number of states
N = gi^ni  ;  // Total no. of miocrostates 
disp("(a) Total no. of miocrostates is ;",N)
function n  = fac(n)
    if  (n<=0) then n=1
    else
        n = n*fac(n-1)
    end
endfunction
P_1 = fac(6)/(fac(6)*fac(0)*fac(0)) ;  // Thermodynamic Probablity for macrostate 1 
disp("(b) Thermodynamic Probablity for macrostate 1 ;",P_1)
P_2 = fac(6)/(fac(5)*fac(1)*fac(0)) ;  // Thermodynamic Probablity for macrostate 2 
disp("Thermodynamic Probablity for macrostate 2 ;",P_2 )
P_3 = fac(6)/(fac(4)*fac(2)*fac(0)) ;  // Thermodynamic Probablity for macrostate 3 
disp("Thermodynamic Probablity for macrostate 3 ;",P_3 )
P_4 = fac(6)/(fac(4)*fac(1)*fac(1)) ;  // Thermodynamic Probablity for macrostate 4 
disp("Thermodynamic Probablity for macrostate 4 ;",P_4 )
P_5 = fac(6)/(fac(3)*fac(2)*fac(1)) ;  // Thermodynamic Probablity for macrostate 5 
disp("Thermodynamic Probablity for macrostate 5 ;",P_5 )
P_6 = fac(6)/(fac(3)*fac(3)*fac(0)) ;  // Thermodynamic Probablity for macrostate 6 
disp("Thermodynamic Probablity for macrostate 6 ;",P_6 )
P_7 = fac(6)/(fac(2)*fac(2)*fac(2)) ;  // Thermodynamic Probablity for macrostate 7 
disp("Thermodynamic Probablity for macrostate 7 ;",P_7 )
omega_1 = P_1*fac(3)/fac(2) ;  // Number of Microstates for macrostate 1 
disp("(c) Number of Microstates for macrostate 1 ;",omega_1 )
omega_2 = P_2*fac(3) ;  // Number of Microstates for macrostate 2 
disp("Number of Microstates for macrostate 2 ;",omega_2 )
omega_3 = P_3*fac(3) ;  // Number of Microstates for macrostate 3 
disp("Number of Microstates for macrostate 3 ;",omega_3 )
omega_4 = P_4*fac(3)/fac(2) ;  // Number of Microstates for macrostate 4 
disp("Number of Microstates for macrostate 4 ;",omega_4 )
omega_5 = P_5*fac(3) ;  // Number of Microstates for macrostate 5 
disp("Number of Microstates for macrostate 5 ;",omega_5 )
omega_6 = P_6*fac(3)/fac(2) ;  // Number of Microstates for macrostate 6 
disp("Number of Microstates for macrostate 6 ;",omega_6 )
omega_7 = P_7*fac(3)/fac(3) ;  // Number of Microstates for macrostate 7 
disp("Number of Microstates for macrostate 7 ;",omega_7 )



/* Result

 
   729.

 (a) Total no. of miocrostates is ;

   1.

  (b) Thermodynamic Probablity for macrostate 1 ;

   6.

 Thermodynamic Probablity for macrostate 2 ;

   15.

 Thermodynamic Probablity for macrostate 3 ;

   30.

 Thermodynamic Probablity for macrostate 4 ;

   60.

 Thermodynamic Probablity for macrostate 5 ;

   20.

 Thermodynamic Probablity for macrostate 6 ;

   90.

 Thermodynamic Probablity for macrostate 7 ;

   3.

 (c) Number of Microstates for macrostate 1 ;

   36.

 Number of Microstates for macrostate 2 ;

   90.

 Number of Microstates for macrostate 3 ;

   90.

 Number of Microstates for macrostate 4 ;

   360.

 Number of Microstates for macrostate 5 ;

   60.

 Number of Microstates for macrostate 6 ;

   90.

 Number of Microstates for macrostate 7 ;

   */
