// Scilab Code for 12.16
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex12_16.txt")
Epsilon1 = 30.1*10^(-3) ; // Energy in level 1 in eV
Epsilon2 = 21.5*10^(-3) ; // Energy in level 2 in eV
Epsilon3 = 12.9*10^(-3) ; // Energy in level 3 in eV
Epsilon4 = 4.3*10^(-3) ; // Energy in level 4 in eV
n1 = 3.1  ;        // Population in level 1
n2 = 8.5  ;        // Population in level 2
n3 = 23  ;        // Population in level 3
n4 = 63  ;        // Population in level 4
Kb = 1.38*10^(-23) ;  // Boltzmann Constnt in J/K
T1 = (Epsilon1-Epsilon2)*1.6*10^(-19)/(log(n2/n1)*Kb)  ;  // Temperature T1 in Kelvin
disp("Temperature T1 in Kelvin is  ;",T1)
T2 = (Epsilon2-Epsilon3)*1.6*10^(-19)/(log(n3/n2)*Kb)  ;  // Temperature T2 in Kelvin
disp("Temperature T2 in Kelvin is  ;",T2)



/* Result
 
  
   98.853672

 Temperature T1 in Kelvin is  ;

   100.16811     ,   "Answer varies due to round off error"

 Temperature T2 in Kelvin is  ;
 
   */
