// Scilab Code for 9.12
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex9_12.txt")
/*
ln p = 23.03-3754/T 
ln p = 19.49-3063/T

equating both pressure we can solve for T
*/
R = 8.314 ; // Gas Constant in J/(mol K)
T_tr = (3754-3063)/(23.03-19.49) ;       // Triple point temperature in Kelvin
disp("(a) Triple point temperature in Kelvin ;",T_tr)

// Using , ln p = 23.03-3754/T
p = exp(23.03 - (3754/T_tr)) ;  // Triple point Pressure in Pa
disp(" Triple point Pressure in mm of Hg is ;",p)

/*
we know dp/dT = L/(TV)
and using ,  ln p = 19.49-3063/T
takind differentiaiton we get 
       dp/dT = 3063p/T^2
       
       so L = TVdp/dT


*/
L_vap = 3063*R ; // Latent heat in J/mol
disp("(b) Latent heat of Vapourisation in J/mol is ;",L_vap)
L_sub = 7508*4.2 ;  // Latent heat of sublimation in J/mol 
L_mel = L_sub - L_vap ;  // Latent heat of melting in J/mol
disp("(c) Latent heat of melting in J/mol is ;",L_mel)
disp(" Latent heat of melting in cal/mol is ;",L_mel/4.2)


/* Result

 
   195.19774

 (a) Triple point temperature in Kelvin ;

   44.621686

  Triple point Pressure in mm of Hg is ;

   25465.782

 (b) Latent heat of Vapourisation in J/mol is ;

   6067.818

 (c) Latent heat of melting in J/mol is ;

   1444.7186

  Latent heat of melting in cal/mol is ;
 "Answer varies due to round off error"
   */
