// Scilab Code for 2.3
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex2_3.txt")
d = 10^(-10) ;  //  Molecular diameter in m
Na = 6*10^(23) ; // Avagadro Number per mol
R = 8.4  ; // Gas constant in J mol^(-1) K^(-1)
V = 20 ; //  Volume in litre 
T = 20  ;  // temperature in Kelvin
M = 4*10^(-3) ; //  Molar mass of helium in Kg/mol
n= Na/(V*10^(-3)) ;  //  Number density in per m^3
lambda = 1/(sqrt(2)*%pi*d^2*n)  ;  // mean free path in m
disp(" mean free path in  10^(-7) m is ; ",lambda/10^(-7) )
Vmean = sqrt(2.55*R*T/M) ; // mean speed in m/sec
disp(" mean speed in m/sec is; ",Vmean)
Pc = Vmean/lambda ;  //  Collision frequency in per sec
disp( " Collision frequency in per sec is ;",Pc)
Tau = 1/Pc ;  // Mean free time in sec
disp( " Mean free time in sec ;",Tau)


/*  Result    
   
   7.502636

  mean free path in  10^(-7) m is ; 

   327.26136     , "Answer vary due to round off error"

  mean speed in m/sec is; 
 
   4.362D+08     , "Answer vary due to round off error"

  Collision frequency in per sec is ;

   2.293D-09    , "Answer(mean free time) given in textbook is wrong "

  Mean free time in sec ;
   
    */
