// Scilab Code for 14.9
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex14_9.txt")
m_e = 9.1*10^(-31)  ;  // Mass of electron in Kg
m_n = 1.67*10^(-27)  ;  // Mass of neutron in Kg
N = 4.2*10^21  ;  // Number of particles
V = 1    ;     // Volume in Cm^3
h = 6.62*10^(-34)  ;  // Plancks constant in J s
eV = 1.6*10^(-19)  ;    //  1 joule is 1.6*10^(-19) eV
lamda_F = (10^7)*(8*%pi*V/(3*N))^(1/3)  ;  // Fermi Wavelength in nm ( 10^7 is used to convert wavelength from cm to nm )
disp(lamda_F,"Fermi Wavelength in nm is  ")
Epsilon_f_electron = (1/(2*m_e))*(h*10^9/lamda_F)^2   ; // Fermi Energy of electron in J
disp(Epsilon_f_electron,"Fermi Energy of electron in J is " )
Epsilon_f_neutron =  (m_e/m_n)*Epsilon_f_electron  ; // Fermi Energy of neutron in J
disp(Epsilon_f_neutron,"Fermi Energy of neutron in J is " )
disp(Epsilon_f_neutron/eV,"Fermi Energy of neutron in eV is " )
/* Result
Fermi Wavelength in nm is  

   1.2587991

 Fermi Energy of electron in J is 

   1.520D-19

 Fermi Energy of neutron in J is 

   8.281D-23

 Fermi Energy of neutron in eV is 

   0.0005175
   
   "Answer Varies due to round off error"
   
   
   */
