// Scilab Code for 14.7
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex14_7.txt")
h = 6.62*10^(-34)  ;  // Plancks constant in J s
m = 9.11*10^(-31)  ;  // Mass of electron in Kg
d = 8.94*10^3  ;  // Density of Al in Kg /m^3
N_A = 6.023*10^23   ;   // Avagadro Number per mol
M = 63.57   ;  // Atomic Weight of Al
Epsilon_f = ((h^2/(8*m))*(3*2*N_A*d/(%pi*M))^(2/3))   ; // Fermi Energy in J
disp("Fermi Energy in eV is ;",Epsilon_f/(1.6*10^(-19))) 


/* Result

 Fermi Energy in eV is 

   0.1115432
   */
