// Scilab Code for 5.16
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex5_16.txt")
pi = 1 ;  // Initial Pressure of a perfect gas in N/m^2
pf = 3 ;  // Final Pressure of a perfect gas in N/m^2
Ta = 300 ; // Temperature at state a in Kelvin
Tc = 900 ; // Temperature at state c in Kelvin
R = 8314 ;  //  Gas Constant in J Kmol^(-1) K^(-1)
Tb  = Ta*(pf/pi) ;  //  Temperature at state b in Kelvin
disp(" Temperature at state b in Kelvin , Tb = ;",Tb)
delta_T = Tb - Ta ;  // Temperature difference in Kelvin 
disp(" Temperature difference in Kelvin , delta_T =  ;",delta_T)
Cv = (5/2)*R ;   // Specefic heat at constant volume in J Kmol^(-1) K^(-1) 
mu = 1 ;  // Number of Kmoles
dU_ab = mu*Cv*delta_T ;  //  Change in  internal energy in J
disp(" Change in  internal energy from a to b in 10^7 J is ;",dU_ab/10^7)
Vf_Vi = pf/pi ;  // Ratio of final and initial volume
W = 2.3*mu*R*Tb*log10(Vf_Vi) ; // Work done by an ideal gas during isothermal expansion in J
disp(" Work done by an ideal gas during isothermal expansion in 10^7 J is ;",W/10^7) 
dU_ca = (5/2)*mu*R*(Ta-Tc) ;  //  Change in  internal energy from c to a in J
disp(" Change in  internal energy from c to a in 10^7 J is ;",dU_ca/10^7)
delta_Q = (7/2)*mu*R*(Ta-Tc) ;  // Heat given out at constant pressure in J
disp(" Heat given out at constant pressure in 10^7 J is ;",delta_Q/10^7)
delta_W = delta_Q - dU_ca ;  //  Work done on the gas in J 
disp(" Work done on the gas in 10^7 J  is  ;",delta_W/10^7)
del_W = W + delta_W ; // Net Work done by the gas in J
disp(" Net Work done by the gas in 10^7 J is ;",del_W/10^7)

/* Result 

   900.

  Temperature at state b in Kelvin , Tb = ;

   600.

  Temperature difference in Kelvin , delta_T =  ;

    1.2471

  Change in  internal energy from a to b in 10^7 J is ;

   0.8211247

  Work done by an ideal gas during isothermal expansion in 10^7 J is ;

  -1.2471

  Change in  internal energy from c to a in 10^7 J is ;

  -1.74594

  Heat given out at constant pressure in 10^7 J is ;

  -0.49884        , " Answer given in Textbook is wrong "

  Work done on the gas in 10^7 J  is  ;

   0.3222847     , " Answer given in Textbook is wrong "

  Net Work done by the gas in 10^7 J is ;
 
 
*/  
