// Scilab Code for 2.10
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex2_10.txt")
rho = 1.6  ;     //   density of gas in Kgm^(-3)
Vmean = 480 ;     //   Average speed in m/sec
lambda = 8*10^(-8) ; //  Mean free path in m 
Y = 1.4 ;   //      Adiabatic constant
R = 8.31*10^3  ;  //  J Kmol^(-1) K^(-1)
M = 32 ;   // molar mass of the gas in Kg Kmol^(-1)
Cv = (5/2)*R ;   //  specefic Heat in J Kmol^(-1) K^(-1)
disp(" specefic Heat in J Kmol^(-1) K^(-1) is ;",Cv)
K = (Cv*rho*lambda*Vmean)/(3*M) ;  // Thermal Conductivity of gas in J m^(-1) s^(-1) K^(-1)
disp(" Thermal Conductivity of gas in J m^(-1) s^(-1) K^(-1) is ;",K)

/* Result 

  20775.

  specefic Heat in J Kmol^(-1) K^(-1) is ;

   0.013296

  Thermal Conductivity of gas in J m^(-1) s^(-1) K^(-1) is ;
  
  "Answer vary due to roundoff error"

   */
