// Scilab Code for 14.4
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex14_4.txt")
h = 6.62*10^(-34)  ;  // Plancks constant in J s
me = 9.11*10^(-31)  ;  // Mass of electron in Kg
Kb = 1.38*10^(-23) ;  // Boltzmann Constnt in J/K
T = 100 ;  // Temperature un Kelvin
NA = 6.02*10^26   ;   // Avagadro Number per mol
R = 8.314  ;   // gas Constsnt
Epsilon_f = 18.66*10^(-19)   ; // Fermi Energy in J
Mf = sqrt(2*me*Epsilon_f)  ;  // Fermi Momentum in Kg m /s
disp("Fermi Momentum in Kg m /s  is ;",Mf)
disp("Fermi momentum in m/s  is ;",Mf/me)
Tf = Epsilon_f/Kb  ;  // Fermi tempertaure in Kelvin
disp("Fermi tempertaure in Kelvin is  ;",Tf)
disp("Average energy per electron in ev ;",3*Epsilon_f/(5*1.6*10^(-19)))
Cv = (%pi^2)*Kb*T*NA/(2*Tf);  // Electronic Heat Capacity in J K^(-1) mol^(-1)
disp("Electronic Heat Capacity in J K^(-1) mol^(-1) is  ;",Cv)



/* result

   1.844D-24

 Fermi Momentum in Kg m /s  is ;

   2024005.2

 Fermi momentum in m/s  is ;

   135217.39

 Fermi tempertaure in Kelvin is  ;

   6.9975

 Average energy per electron in ev ;

   30.318853

 Electronic Heat Capacity in J K^(-1) mol^(-1) is  ;
 
 "Answer varies due to round off error "

   */
   
