// Scilab Code for 13.9
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex13_9.txt")
T1 = 30 ;  // Temperature in Kelvin
T2 = 50 ;  // Temperature in Kelvin
theta_D = 2230 ;  // Debye Temperature un Kelvin
Kb = 1.38*10^(-23) ;  // Boltzmann Constnt in J/K
R = 8.314  ;   // gas Constsnt
h = 6.62*10^(-34)  ;  // Plancks constant in J s
Cv = (12*(%pi^4)*R/5)*(T1/theta_D)^3 ;  // Specefic heta Capacity ofsolid in J K^(-1) mol^(-1)
disp("Specefic heta Capacity ofsolid in 10^(-3) J K^(-1) mol^(-1) is ;",Cv/10^(-3))
funcprot(0)
function I=f(T)
    I = (12*(%pi^4)*R*T^2)/(5*(theta_D)^3) ;   // integral  Cv/T
endfunction
T1 = 30;    // Lower limit
T2 = 50;    //  upper limit
del_S = intg(T1,T2,f);   //   change in entropy 
disp(" Change in entropy in 10^(-3) J K^(-1) mol^(-1) ;",del_S/10^(-3))
v_m = Kb*theta_D/h  ;  // Maximum Lattice Frequency in Hz
disp("Maximum Lattice Frequency in Hz is ;",v_m)



/* Result
 
   4.7322745

 Specefic heta Capacity ofsolid in 10^(-3) J K^(-1) mol^(-1) is ;

   5.7254679

  Change in entropy in 10^(-3) J K^(-1) mol^(-1) ;

   4.649D+13

 Maximum Lattice Frequency in Hz is ;
   */
