// Scilab Code for 11.4
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex11_4.txt")
T0 = 300  ;  //  Temperature in Kelvin
T = 310 ;  // Temperature in Kelvin
T_av = (T0+T)/2  ; // Average Temperature in Kelvin
A = 6*(25*10^(-4)) ;  // Area of Cube in m^2
sigma = 5.67*10^(-8) ; // Stephen's Constant  
m = 125 ; // Mass in gram 
s = 1 ;  // Specefic Heat of the water in g/cm^3
Q = m*s*(T-T0) ; // Heat lost by the water in cal
disp(" Heat lost by the water in cal is ;",Q)
t = (Q*4.2)/(A*sigma*(T_av^4 - T0^4)) ;  // Time in sec
disp("Time in which Temperature falls in hrs is ;",(t/3600))
disp("Time in which Temperature falls is 3 hr and  5.822346 ")


/* Result
 
   1250.

  Heat lost by the water in cal is ;

   3.0970391             

 Time in which Temperature falls in hrs is ;

 Time in which Temperature falls is 3 hr and  5.822346
 
 Time 3.0970391 hrs is equivalent to 3 hrs and 5.8822346 minutes 
 
 "Answer varies due to round off error"

   */
