// Scilab Code for 11.18
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex11_18.txt")
sigma = 5.7*10^(-5) ;   // Stephen's Constant in erg cm^(-2) K^(-4) s^(-1)
A = 4*%pi*(10)^2   ;   // Area in cm^2
T = 127+273 ;   // Temperature in Kelvin
T0 = 27+273 ;   // Temperature in Kelvin
m = 5*10^3  ;  // mass in g
dtheta_dt = 3*10^(-2)  ;  //  Rate of Fall of temperature 
c = 4.2*10^7 //  conversion   J / Kg to cal / g
s = sigma*A*(T^4 - T0^4)/(m*dtheta_dt*c)  ;   // specefic heat Capacity of the metal in cal g^(-1) C^(-1)
disp("specefic heat Capacity of the metal in cal g^(-1) C^(-1)  is  ;",s)



/* Result


   0.1989675

 specefic heat Capacity of the metal in cal g^(-1) C^(-1)  is  ;
 
 
 "Answer varies due to round off error"
   */
